@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4">Hasil Pemeriksaan Pasien</h1>
                <p class="text-lg sm:text-xl text-gray-600">Akses hasil pemeriksaan Anda dengan mudah dan aman</p>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-none">
                <div class="p-8 text-gray-900">
                    @if (!isset($patient))
                        <!-- Form Login -->
                        <div class="max-w-md mx-auto">
                            <div class="text-center mb-8">
                                <div
                                    class="w-16 h-16 bg-[#192D50] rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                        </path>
                                    </svg>
                                </div>
                                <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2">Cari Hasil Pemeriksaan</h3>
                                <p class="text-gray-600">Masukkan nomor rekam medis dan password Anda</p>
                            </div>

                            <form method="POST" action="{{ route('results.patient.check') }}" class="space-y-6">
                                @csrf

                                <div>
                                    <label for="mrn" class="block text-sm font-medium text-gray-700 mb-2">No. Rekam
                                        Medis (MRN)</label>
                                    <input type="text" id="mrn" name="mrn" value="{{ old('mrn') }}" required
                                        autofocus
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('mrn')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="password"
                                        class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                                    <input type="password" id="password" name="password" required
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('password')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="flex items-center justify-end">
                                    <button type="submit"
                                        class="bg-[#192D50] text-white px-6 py-3 rounded-none font-semibold hover:bg-[#192D50] transition duration-150">
                                        Cari
                                    </button>
                                </div>
                            </form>
                        </div>
                    @else
                        <!-- Hasil Pemeriksaan -->
                        <div class="mb-8">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-[#192D50] rounded-full flex items-center justify-center mr-4">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-xl sm:text-2xl font-bold text-gray-900">Selamat datang, {{ $patient->name }}!</h3>
                                    <p class="text-gray-600">Berikut adalah hasil pemeriksaan Anda:</p>
                                </div>
                            </div>
                        </div>

                        @if ($examResults->count() > 0)
                            <div class="space-y-6">
                                @foreach ($examResults as $result)
                                    <div
                                        class="bg-gray-50 border border-gray-200 p-6 rounded-none hover:shadow-md transition duration-150">
                                        <div class="flex justify-between items-start mb-4">
                                            <div class="flex-1">
                                                <h4 class="text-lg font-semibold text-gray-900 mb-2">
                                                    {{ ucfirst($result->exam_type) }}</h4>
                                                <p class="text-sm text-gray-600 mb-2">
                                                    <span class="font-medium">Tanggal:</span>
                                                    {{ $result->exam_date->format('d F Y') }}
                                                </p>
                                                @if ($result->notes)
                                                    <p class="text-sm text-gray-600 mt-2">{{ $result->notes }}</p>
                                                @endif
                                            </div>
                                            <div class="flex items-center space-x-3">
                                                <span
                                                    class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                                                    @if ($result->status == 'completed') bg-green-100 text-green-800
                                                    @elseif($result->status == 'pending') bg-yellow-100 text-yellow-800
                                                    @else bg-red-100 text-red-800 @endif">
                                                    {{ ucfirst($result->status) }}
                                                </span>
                                            </div>
                                        </div>

                                        <!-- File Section -->
                                        @if ($result->result_file_path)
                                            <div class="bg-white border border-gray-200 rounded-none p-4">
                                                <div class="flex items-center justify-between">
                                                    <div class="flex items-center">
                                                        <div
                                                            class="w-10 h-10 bg-[#192D50] rounded-none flex items-center justify-center mr-3">
                                                            <svg class="w-5 h-5 text-white" fill="none"
                                                                stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                                </path>
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <p class="text-sm font-medium text-gray-900">File Hasil
                                                                Pemeriksaan</p>
                                                            <p class="text-xs text-gray-500">
                                                                {{ basename($result->result_file_path) }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="flex items-center space-x-2">
                                                        <a href="{{ route('results.file.view', $result->id) }}"
                                                            target="_blank"
                                                            class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50]">
                                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z">
                                                                </path>
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                                                </path>
                                                            </svg>
                                                            Lihat
                                                        </a>
                                                        <a href="{{ route('results.file.download', $result->id) }}"
                                                            class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50]">
                                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                                </path>
                                                            </svg>
                                                            Download
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <div class="bg-[#192D50] border border-white rounded-none p-4">
                                                <div class="flex items-center">
                                                    <div class="w-5 h-5 text-[#CBB4B0] mr-2">
                                                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                    <p class="text-sm text-[#CBB4B0]">File hasil pemeriksaan belum
                                                        tersedia</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-12">
                                <div
                                    class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-gray-100 mb-4">
                                    <svg class="h-8 w-8 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                </div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Belum Ada Hasil</h3>
                                <p class="text-gray-600 mb-6">
                                    Belum ada hasil pemeriksaan yang tersedia.
                                    Silakan cek kembali nanti atau hubungi klinik.
                                </p>
                                <a href="{{ route('registration.create') }}"
                                    class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-none text-white bg-[#192D50]">
                                    Daftar Pemeriksaan
                                </a>
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
